'use strict';

/* --------------------------------------------------------------
 online_manual.js 2019-07-12
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

/**
 * Add an icon containing the URL to the online manual reference
 */
(function () {
    'use strict';

    var VISIBLE_CSS_CLASS = 'visible';
    var LINK_TARGET = '_blank';

    var url = document.currentScript.dataset.url;

    var element = void 0;

    function onPageReady() {
        var request = new XMLHttpRequest();
        var requestUrl = url + '&origin=' + encodeURIComponent(window.location.href);

        request.responseType = 'json';

        if (!element) {
            element = document.createElement('a');
            element.classList.add('online-manual-icon');
            document.body.appendChild(element);
        }

        function onLoad() {
            var response = request.response;

            if (this.status !== 200 || !response.link) {
                return;
            }

            element.href = response.link;
            element.title = response.tooltip;
            element.target = LINK_TARGET;
            element.classList.add(VISIBLE_CSS_CLASS);
        }

        request.open('GET', requestUrl, true);
        request.onload = onLoad;
        request.send();
    }

    function onHashChange() {
        element.classList.remove(VISIBLE_CSS_CLASS);
        onPageReady();
    }

    document.addEventListener('JSENGINE_INIT_FINISHED', onPageReady);
    window.addEventListener('hashchange', onHashChange);
})();
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
